#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Ray Marching Mob Programming 1Mod01.fsh  by   lesleylai
//https://www.shadertoy.com/view/sdlyD8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float sphereSdf(vec3 pos, vec3 origin, float radius) {
  return distance(pos, origin) - radius;
}

#define PI 3.1415926
  float de(vec3 p){
    float rt = 15.;
    float rg = 4.;
    float ws = 0.3;

    p.xz = vec2 (rt * atan (p.z, - p.x), length (p.xz) - rt);
    p.yz = vec2 (rg * atan (p.z, - p.y), length (p.yz) - rg);
    return .6* max(abs(dot(sin(p), cos(p).yzx)) - ws, abs(p.z) - .5*PI);
  }


float sceneSdf(vec3 pos) {
  return min(min(sphereSdf(pos, vec3(-1.0, 0.6*sin(iTime * 0.4), -2.0), 0.5),
             sphereSdf(pos, vec3(1.0, 0.6*sin(iTime * 0.4), -2.0), 0.5)),
             de(pos));
}

vec3 sceneNormal(vec3 pos) {
  const float epsilon = 1e-4;
  float dist = sceneSdf(pos);
  float dx = sceneSdf(pos + vec3(epsilon, 0.0, 0.0)) - dist;
  float dy = sceneSdf(pos + vec3(0.0, epsilon, 0.0)) - dist;
  float dz = sceneSdf(pos + vec3(0.0, 0.0, epsilon)) - dist;
  return normalize(vec3(dx, dy, dz));
}

bool rayMarching(inout vec3 origin, vec3 direction) {
  float nextDist = 1000000.0;
  const float epsilon = 1e-3;
  float t = 0.0;
  for (int i = 0; i < 50; ++i) {
    nextDist = sceneSdf(origin);
    t += nextDist;
    if (nextDist < epsilon) {
      return true;
    }
    origin += direction * nextDist;
  }
  return false;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy * 2. - 1.;
    uv.y *= iResolution.y / iResolution.x;
    
    vec3 direction = normalize(vec3(uv, -1.0));
    
    vec3 origin = vec3(0.0);
    bool hit = rayMarching(origin, direction);
    vec3 col = vec3(0.0);
    if (hit) {
      const vec3 lightPos = vec3(0.0, 0.0, -2.0);
      vec3 lightDir = normalize(lightPos - origin);
      float lightDistance = sqrt(dot(lightDir, lightDir));
      vec3 normal = sceneNormal(origin);
      col = normal * 0.5 + 0.5;
      col *= 1.0 / (lightDistance * lightDistance);
      col *= dot(normal, lightDir);
    }

    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

